/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.query;

import filenet.vw.api.IVWTableDefinition;
import filenet.vw.api.VWException;
import filenet.vw.api.VWExposedFieldDefinition;
import filenet.vw.api.VWIndexDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.event.IVWExpressionToolbarActionListener;
import filenet.vw.toolkit.utils.event.VWExpressionToolbarActionEvent;
import filenet.vw.toolkit.utils.query.IVWScopeChangeListener;
import filenet.vw.toolkit.utils.query.VWDateTimeErrDialog;
import filenet.vw.toolkit.utils.query.VWFieldListRenderer;
import filenet.vw.toolkit.utils.query.VWIndexDialog;
import filenet.vw.toolkit.utils.query.VWIndexListRenderer;
import filenet.vw.toolkit.utils.query.VWPerformSearchEvent;
import filenet.vw.toolkit.utils.query.VWScopeChangeEvent;
import filenet.vw.toolkit.utils.resources.VWResource;
import filenet.vw.toolkit.utils.table.VWFieldsCellEditor;
import filenet.vw.toolkit.utils.table.VWLabelListCellRenderer;
import filenet.vw.toolkit.utils.uicontrols.expressionbuilder.VWExpressionToolbar;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.text.ParseException;
import java.util.Date;
import javax.accessibility.Accessible;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class VWFilterConditionsPanel
extends JPanel
implements IVWScopeChangeListener,
ActionListener,
IVWExpressionToolbarActionListener {
    private static final int OFFSET_HORIZ = 10;
    private JComboBox m_fieldsCombo = null;
    private JComboBox m_operatorsCombo = null;
    private JComboBox m_indexCombo = null;
    private JTextArea m_filterString = null;
    private JTextField m_dataTextField = null;
    private JButton m_insertButton = null;
    private JButton m_advancedButton = null;
    private IVWTableDefinition m_definition = null;
    private String m_defaultIndexName = null;
    private boolean m_bShowFifoIndex = true;
    private VWExpressionToolbar m_toolbar = null;
    private VWIndexDialog m_indexDlg = null;
    private Color m_enabledBkgrndColor = SystemColor.text;

    public VWFilterConditionsPanel(String defaultIndexName) {
        try {
            this.m_defaultIndexName = defaultIndexName;
            this.initialize();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public VWFilterConditionsPanel(String defaultIndexName, boolean showFifoIndex) {
        try {
            this.m_bShowFifoIndex = showFifoIndex;
            this.m_defaultIndexName = defaultIndexName;
            this.initialize();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public String getDisplayName() {
        return VWResource.s_criteria;
    }

    public String getFilterString() {
        if (this.m_filterString != null) {
            return this.m_filterString.getText();
        }
        return null;
    }

    public void getIndexParameters(VWPerformSearchEvent event) {
        if (event == null) {
            return;
        }
        event.setIndexFlags(this.m_indexDlg.getQueryFlags());
        event.setIndexName(this.m_indexDlg.getIndexName());
        event.setMaxValues(this.m_indexDlg.getMaxValues());
        event.setMinValues(this.m_indexDlg.getMinValues());
    }

    public void removeReferences() {
        DefaultComboBoxModel dataModel;
        if (this.m_indexDlg != null) {
            this.m_indexDlg.removeReferences();
            this.m_indexDlg = null;
        }
        if (this.m_fieldsCombo != null) {
            dataModel = (DefaultComboBoxModel)this.m_fieldsCombo.getModel();
            if (dataModel != null && dataModel.getSize() > 0) {
                dataModel.removeAllElements();
            }
            this.m_fieldsCombo = null;
        }
        if (this.m_operatorsCombo != null) {
            this.m_operatorsCombo.removeAllItems();
            this.m_operatorsCombo = null;
        }
        if (this.m_indexCombo != null) {
            dataModel = (DefaultComboBoxModel)this.m_indexCombo.getModel();
            if (dataModel != null && dataModel.getSize() > 0) {
                dataModel.removeAllElements();
            }
            this.m_indexCombo = null;
        }
        this.m_toolbar = null;
        this.m_filterString = null;
        this.m_dataTextField = null;
        this.m_definition = null;
        this.m_defaultIndexName = null;
    }

    public void scopeChanged(VWScopeChangeEvent event) {
        try {
            this.m_definition = event.getDefinitionObject();
            this.initializeFieldsComboBox();
            this.resetOperatorsCombo();
            this.m_dataTextField.setText("");
            this.m_filterString.setText("");
            this.resetIndexComboBox();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.m_insertButton || source == this.m_dataTextField) {
            this.updateFilterString();
        } else if (source == this.m_advancedButton) {
            this.m_indexDlg.setDefaults();
            this.m_indexDlg.setVisible(true);
        } else if (source == this.m_indexCombo) {
            VWIndexDefinition indexDef = null;
            if (this.m_indexCombo.getSelectedIndex() < 1) {
                indexDef = null;
                this.m_advancedButton.setEnabled(false);
            } else {
                indexDef = (VWIndexDefinition)this.m_indexCombo.getSelectedItem();
                if (indexDef != null) {
                    String[] fieldNames = indexDef.getFieldNames();
                    if (fieldNames == null || fieldNames.length == 0) {
                        this.m_advancedButton.setEnabled(false);
                    } else {
                        this.m_advancedButton.setEnabled(true);
                    }
                }
            }
            if (this.m_indexDlg != null) {
                this.m_indexDlg.resetTable(indexDef);
            }
        } else if (source == this.m_fieldsCombo) {
            this.resetOperatorsCombo();
            this.m_dataTextField.setText("");
            this.m_dataTextField.setEnabled(true);
            this.m_dataTextField.setBackground(this.m_enabledBkgrndColor);
        } else if (source == this.m_operatorsCombo) {
            String op = (String)this.m_operatorsCombo.getSelectedItem();
            if (VWStringUtils.compare(op, VWResource.s_isNotNullOp) == 0 || VWStringUtils.compare(op, VWResource.s_isNullOp) == 0) {
                this.m_dataTextField.setText("");
                this.m_dataTextField.setEnabled(false);
                this.m_dataTextField.setBackground(this.getBackground());
            } else {
                this.m_dataTextField.setEnabled(true);
                this.m_dataTextField.setBackground(this.m_enabledBkgrndColor);
            }
        }
    }

    public void expressionToolbarActionPerformed(VWExpressionToolbarActionEvent event) {
        Object src = event.getSource();
        if (src == this.m_toolbar) {
            int eventID = event.getID();
            switch (eventID) {
                case 3: {
                    this.resetFilterConditionsTab();
                    break;
                }
                case 4: {
                    String operatorString = event.getData().toString();
                    this.m_filterString.append(operatorString);
                    break;
                }
            }
        }
    }

    protected static Date convertToDate(String aString) {
        Date date = null;
        if (aString != null && aString.length() > 0) {
            int nCount = VWFieldsCellEditor.s_dateTimeFormatters.length;
            for (int i = 0; i < nCount; ++i) {
                try {
                    date = VWFieldsCellEditor.s_dateTimeFormatters[i].parse(aString);
                    if (date == null) continue;
                    break;
                }
                catch (ParseException ex) {
                    if (i != nCount - 1) continue;
                    VWDateTimeErrDialog errDlg = new VWDateTimeErrDialog(null, VWResource.s_error, VWResource.s_invalidDateTimeFormat, 0);
                    errDlg.setVisible(true);
                    date = null;
                }
            }
        }
        return date;
    }

    private void initialize() {
        try {
            this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.gridwidth = 0;
            gbCons.anchor = 23;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            gbCons.weighty = 0.0;
            gbCons.insets = new Insets(2, 0, 4, 2);
            this.add((Component)this.createIndexPanel(), gbCons);
            this.add((Component)this.createOptionsPanel(), gbCons);
            gbCons.insets = new Insets(2, 0, 0, 2);
            this.add((Component)this.createOperationsPanel(), gbCons);
            gbCons.fill = 1;
            gbCons.weighty = 1.0;
            gbCons.insets = new Insets(0, 0, 2, 2);
            this.m_filterString = new JTextArea();
            this.m_filterString.setLineWrap(true);
            this.m_filterString.addFocusListener(new FocusAdapter(){

                public void focusGained(FocusEvent e) {
                    if (e != null && e.getSource() != null && e.getSource() instanceof JTextArea) {
                        Container parent = ((JTextArea)e.getSource()).getParent();
                        VWAccessibilityHelper.setAccessibility(VWFilterConditionsPanel.this.m_filterString, (Accessible)((Object)parent), VWFilterConditionsPanel.this.m_filterString.getText(), null);
                    }
                }

                public void focusLost(FocusEvent e) {
                }
            });
            this.add((Component)new JScrollPane(this.m_filterString), gbCons);
            this.m_insertButton.addActionListener(this);
            this.m_advancedButton.addActionListener(this);
            this.m_dataTextField.addActionListener(this);
            this.m_toolbar.addExpressionToolbarActionListener(this);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private JPanel createIndexPanel() throws Exception {
        JPanel mainPanel = null;
        try {
            mainPanel = new JPanel();
            mainPanel.setLayout(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.gridwidth = 1;
            gbCons.gridheight = 1;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            gbCons.anchor = 23;
            gbCons.fill = 0;
            gbCons.ipadx = 0;
            gbCons.ipady = 0;
            gbCons.fill = 0;
            gbCons.insets = new Insets(0, 5, 0, 5);
            JLabel indexLabel = new JLabel(VWResource.s_useIndex);
            VWAccessibilityHelper.setAccessibility(indexLabel, this, VWResource.s_useIndex, VWResource.s_useIndex);
            mainPanel.add((Component)indexLabel, gbCons);
            this.m_indexCombo = new JComboBox();
            this.m_indexCombo.setRenderer(new VWIndexListRenderer());
            this.m_indexCombo.addActionListener(this);
            VWAccessibilityHelper.setAccessibility(this.m_indexCombo, this, VWResource.s_useIndex, VWResource.s_useIndex);
            VWAccessibilityHelper.setLabelFor(indexLabel, this.m_indexCombo);
            ++gbCons.gridx;
            gbCons.fill = 2;
            gbCons.weightx = 0.6;
            gbCons.insets = new Insets(0, 0, 0, 30);
            mainPanel.add((Component)this.m_indexCombo, gbCons);
            this.m_advancedButton = new JButton(VWResource.s_advancedDots);
            VWAccessibilityHelper.setAccessibility(this.m_advancedButton, this, VWResource.s_advancedDots, VWResource.s_advancedDots);
            this.m_advancedButton.setEnabled(false);
            this.m_advancedButton.setMargin(new Insets(0, 0, 0, 0));
            ++gbCons.gridx;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.insets = new Insets(0, 0, 0, 140);
            mainPanel.add((Component)this.m_advancedButton, gbCons);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            throw ex;
        }
        return mainPanel;
    }

    private JPanel createOptionsPanel() throws Exception {
        JPanel mainPanel = null;
        try {
            mainPanel = new JPanel();
            mainPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            mainPanel.setLayout(new BoxLayout(mainPanel, 2));
            mainPanel.add(this.createSearchFieldsPanel());
            mainPanel.add(Box.createHorizontalStrut(10));
            mainPanel.add(this.createOperatorsPanel());
            mainPanel.add(Box.createHorizontalStrut(10));
            mainPanel.add(this.createValuePanel());
            mainPanel.add(Box.createHorizontalStrut(30));
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            throw ex;
        }
        return mainPanel;
    }

    private JPanel createSearchFieldsPanel() throws Exception {
        JPanel mainPanel = null;
        try {
            mainPanel = new JPanel();
            mainPanel.setAlignmentX(0.0f);
            mainPanel.setAlignmentY(1.0f);
            mainPanel.setLayout(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.gridwidth = 0;
            gbCons.anchor = 21;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            gbCons.weighty = 0.0;
            JLabel searchFieldsLabel = new JLabel(VWResource.s_searchFields);
            VWAccessibilityHelper.setAccessibility(searchFieldsLabel, this, VWResource.s_searchFields, VWResource.s_searchFields);
            mainPanel.add((Component)searchFieldsLabel, gbCons);
            this.m_fieldsCombo = new JComboBox();
            this.m_fieldsCombo.setRenderer(new VWFieldListRenderer());
            this.m_fieldsCombo.addActionListener(this);
            VWAccessibilityHelper.setAccessibility(this.m_fieldsCombo, this, VWResource.s_searchFields, VWResource.s_searchFields);
            VWAccessibilityHelper.setLabelFor(searchFieldsLabel, this.m_fieldsCombo);
            mainPanel.add((Component)this.m_fieldsCombo, gbCons);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            throw ex;
        }
        return mainPanel;
    }

    private JPanel createOperatorsPanel() throws Exception {
        JPanel mainPanel = null;
        try {
            mainPanel = new JPanel();
            mainPanel.setAlignmentX(0.0f);
            mainPanel.setAlignmentY(1.0f);
            mainPanel.setLayout(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.gridwidth = 0;
            gbCons.anchor = 21;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            gbCons.weighty = 0.0;
            JLabel operatorLabel = new JLabel(VWResource.s_operator);
            VWAccessibilityHelper.setAccessibility(operatorLabel, this, VWResource.s_operator, VWResource.s_operator);
            mainPanel.add((Component)operatorLabel, gbCons);
            this.m_operatorsCombo = new JComboBox();
            this.m_operatorsCombo.setRenderer(new VWLabelListCellRenderer());
            VWAccessibilityHelper.setAccessibility(this.m_operatorsCombo, this, VWResource.s_operator, VWResource.s_operator);
            VWAccessibilityHelper.setLabelFor(operatorLabel, this.m_operatorsCombo);
            this.m_operatorsCombo.addItem(VWResource.s_isEqualOp);
            this.m_operatorsCombo.addItem(VWResource.s_notEqualOp);
            this.m_operatorsCombo.addItem(VWResource.s_isGreaterThanOp);
            this.m_operatorsCombo.addItem(VWResource.s_isGreaterThanOrEqualOp);
            this.m_operatorsCombo.addItem(VWResource.s_isLessThanOp);
            this.m_operatorsCombo.addItem(VWResource.s_isLessThanOrEqualOp);
            this.m_operatorsCombo.addItem(VWResource.s_likeOp);
            this.m_operatorsCombo.addItem(VWResource.s_notLikeOp);
            this.m_operatorsCombo.addItem(VWResource.s_isNullOp);
            this.m_operatorsCombo.addItem(VWResource.s_isNotNullOp);
            this.m_operatorsCombo.addActionListener(this);
            mainPanel.add((Component)this.m_operatorsCombo, gbCons);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            throw ex;
        }
        return mainPanel;
    }

    private JPanel createValuePanel() throws Exception {
        JPanel mainPanel = null;
        try {
            mainPanel = new JPanel();
            mainPanel.setAlignmentX(0.0f);
            mainPanel.setAlignmentY(1.0f);
            mainPanel.setLayout(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.gridwidth = 0;
            gbCons.anchor = 21;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            gbCons.weighty = 0.0;
            JLabel valueLabel = new JLabel(VWResource.s_label.toString(VWResource.s_value));
            VWAccessibilityHelper.setAccessibility(valueLabel, this, VWResource.s_value, VWResource.s_value);
            mainPanel.add((Component)valueLabel, gbCons);
            JPanel tinyPanel = new JPanel();
            tinyPanel.setLayout(new GridBagLayout());
            GridBagConstraints gb1Cons = new GridBagConstraints();
            gb1Cons.anchor = 21;
            gb1Cons.gridx = 0;
            gb1Cons.weightx = 1.0;
            gb1Cons.fill = 2;
            gb1Cons.insets = new Insets(1, 1, 1, 1);
            this.m_dataTextField = new JTextField(30);
            this.m_enabledBkgrndColor = this.m_dataTextField.getBackground();
            VWAccessibilityHelper.setAccessibility(this.m_dataTextField, this, VWResource.s_value, VWResource.s_value);
            VWAccessibilityHelper.setLabelFor(valueLabel, this.m_dataTextField);
            tinyPanel.add((Component)this.m_dataTextField, gb1Cons);
            this.m_insertButton = new JButton(VWResource.s_insert);
            VWAccessibilityHelper.setAccessibility(this.m_insertButton, this, VWResource.s_insert, VWResource.s_insert);
            this.m_insertButton.setEnabled(true);
            gb1Cons.gridx = -1;
            gb1Cons.weightx = 0.0;
            gb1Cons.fill = 0;
            gb1Cons.insets = new Insets(1, 20, 1, 1);
            tinyPanel.add((Component)this.m_insertButton, gb1Cons);
            mainPanel.add((Component)tinyPanel, gbCons);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            throw ex;
        }
        return mainPanel;
    }

    private VWExpressionToolbar createOperationsPanel() throws Exception {
        try {
            this.m_toolbar = new VWExpressionToolbar(1);
            this.m_toolbar.setEnabled(true);
            return this.m_toolbar;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetIndexComboBox() {
        int nDefaultIndex = 0;
        try {
            this.m_indexCombo.removeActionListener(this);
            DefaultComboBoxModel dataModel = (DefaultComboBoxModel)this.m_indexCombo.getModel();
            if (dataModel.getSize() > 0) {
                dataModel.removeAllElements();
            }
            dataModel.addElement(VWResource.s_default);
            if (this.m_definition != null) {
                if (this.m_indexDlg == null) {
                    for (Container parent = this.getParent(); parent != null; parent = parent.getParent()) {
                        if (parent instanceof Dialog) {
                            this.m_indexDlg = new VWIndexDialog((Dialog)parent);
                            break;
                        }
                        if (!(parent instanceof Frame)) continue;
                        this.m_indexDlg = new VWIndexDialog((Frame)parent);
                        break;
                    }
                }
                this.m_indexDlg.setExposedFields(this.m_definition.getFields());
                VWIndexDefinition[] indexDefs = this.m_definition.getIndexes();
                if (indexDefs != null) {
                    boolean bRemovedFifo = false;
                    for (int i = 0; i < indexDefs.length; ++i) {
                        if (this.m_bShowFifoIndex || VWStringUtils.compare("F_Fifo", indexDefs[i].getName()) != 0) {
                            dataModel.addElement(indexDefs[i]);
                            if (this.m_defaultIndexName == null || VWStringUtils.compare(this.m_defaultIndexName, indexDefs[i].getName()) != 0) continue;
                            this.m_advancedButton.setEnabled(true);
                            if (bRemovedFifo) {
                                nDefaultIndex = i;
                                continue;
                            }
                            nDefaultIndex = i + 1;
                            continue;
                        }
                        bRemovedFifo = true;
                    }
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        finally {
            this.m_indexCombo.addActionListener(this);
            this.m_indexCombo.setSelectedIndex(nDefaultIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeFieldsComboBox() {
        try {
            this.m_fieldsCombo.removeActionListener(this);
            DefaultComboBoxModel<VWExposedFieldDefinition> dataModel = new DefaultComboBoxModel<VWExposedFieldDefinition>(this.m_definition.getFields());
            this.m_fieldsCombo.setModel(dataModel);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        finally {
            this.m_fieldsCombo.addActionListener(this);
            if (this.m_fieldsCombo.getItemCount() > 0) {
                this.m_fieldsCombo.setSelectedIndex(0);
            }
        }
    }

    private void resetFilterConditionsTab() {
        try {
            if (this.m_fieldsCombo.getItemCount() > 0) {
                this.m_fieldsCombo.setSelectedIndex(0);
            }
            this.resetOperatorsCombo();
            if (this.m_operatorsCombo.getItemCount() > 0) {
                this.m_operatorsCombo.setSelectedIndex(0);
            }
            this.m_dataTextField.setText("");
            this.m_filterString.setText("");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void resetOperatorsCombo() {
        try {
            this.m_operatorsCombo.removeAllItems();
            VWExposedFieldDefinition fieldDef = (VWExposedFieldDefinition)this.m_fieldsCombo.getSelectedItem();
            if (fieldDef == null) {
                return;
            }
            switch (fieldDef.getFieldType()) {
                case 2: {
                    this.m_operatorsCombo.addItem(VWResource.s_isEqualOp);
                    this.m_operatorsCombo.addItem(VWResource.s_notEqualOp);
                    this.m_operatorsCombo.addItem(VWResource.s_isGreaterThanOp);
                    this.m_operatorsCombo.addItem(VWResource.s_isGreaterThanOrEqualOp);
                    this.m_operatorsCombo.addItem(VWResource.s_isLessThanOp);
                    this.m_operatorsCombo.addItem(VWResource.s_isLessThanOrEqualOp);
                    this.m_operatorsCombo.addItem(VWResource.s_likeOp);
                    this.m_operatorsCombo.addItem(VWResource.s_notLikeOp);
                    this.m_operatorsCombo.addItem(VWResource.s_isNullOp);
                    this.m_operatorsCombo.addItem(VWResource.s_isNotNullOp);
                    break;
                }
                case 4: {
                    this.m_operatorsCombo.addItem(VWResource.s_isEqualOp);
                    this.m_operatorsCombo.addItem(VWResource.s_notEqualOp);
                    break;
                }
                default: {
                    this.m_operatorsCombo.addItem(VWResource.s_isEqualOp);
                    this.m_operatorsCombo.addItem(VWResource.s_notEqualOp);
                    this.m_operatorsCombo.addItem(VWResource.s_isGreaterThanOp);
                    this.m_operatorsCombo.addItem(VWResource.s_isGreaterThanOrEqualOp);
                    this.m_operatorsCombo.addItem(VWResource.s_isLessThanOp);
                    this.m_operatorsCombo.addItem(VWResource.s_isLessThanOrEqualOp);
                    break;
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void updateFilterString() {
        try {
            VWExposedFieldDefinition fieldDef = (VWExposedFieldDefinition)this.m_fieldsCombo.getSelectedItem();
            if (fieldDef == null) {
                return;
            }
            String value = this.m_dataTextField.getText();
            if ((value == null || value.length() == 0) && fieldDef.getFieldType() != 2) {
                JOptionPane.showMessageDialog(null, VWResource.s_invalidValue, VWResource.s_error, 1, null);
                return;
            }
            switch (fieldDef.getFieldType()) {
                case 16: {
                    Date aDate = VWFilterConditionsPanel.convertToDate(value);
                    if (aDate != null) {
                        long lValue = aDate.getTime() / 1000L;
                        Long LValue = new Long(lValue);
                        this.appendToFilterString(LValue.toString());
                    }
                    break;
                }
                case 1: {
                    try {
                        Integer newIntValue = new Integer(value);
                        this.appendToFilterString(newIntValue.toString());
                    }
                    catch (NumberFormatException ex) {
                        JOptionPane.showMessageDialog(null, VWResource.s_invalidIntegerFormat, VWResource.s_error, 1, null);
                    }
                    break;
                }
                case 8: {
                    try {
                        Double newFloatValue = new Double(value);
                        this.appendToFilterString(newFloatValue.toString());
                    }
                    catch (NumberFormatException ex) {
                        JOptionPane.showMessageDialog(null, VWResource.s_invalidFloatFormat, VWResource.s_error, 1, null);
                    }
                    break;
                }
                case 2: {
                    String op = (String)this.m_operatorsCombo.getSelectedItem();
                    if (VWStringUtils.compare(op, VWResource.s_isNotNullOp) == 0 || VWStringUtils.compare(op, VWResource.s_isNullOp) == 0) {
                        this.appendToFilterString(null);
                        return;
                    }
                    String sValue = this.m_dataTextField.getText();
                    if (sValue != null && sValue.length() > 0) {
                        if (!sValue.startsWith("'")) {
                            sValue = "'" + sValue;
                        }
                        if (!sValue.endsWith("'")) {
                            sValue = sValue + "'";
                        }
                        int nIndex = 0;
                        int startIndex = 0;
                        while ((nIndex = sValue.indexOf("'", startIndex)) != -1) {
                            if (nIndex != 0 && nIndex != sValue.length() - 1) {
                                String smallString = sValue.substring(0, nIndex);
                                String anotherString = sValue.substring(nIndex, sValue.length());
                                sValue = smallString + "'" + anotherString;
                                startIndex = nIndex + 2;
                                continue;
                            }
                            if (nIndex == sValue.length() - 1) break;
                            ++startIndex;
                        }
                        this.appendToFilterString(sValue);
                        break;
                    }
                    this.appendToFilterString("''");
                    break;
                }
                case 4: {
                    if (VWStringUtils.compareIgnoreCase(value, VWResource.s_true) == 0 || VWStringUtils.compareIgnoreCase(value, "1") == 0) {
                        this.appendToFilterString("1");
                        break;
                    }
                    if (VWStringUtils.compareIgnoreCase(value, VWResource.s_false) == 0 || VWStringUtils.compareIgnoreCase(value, "0") == 0) {
                        this.appendToFilterString("0");
                        break;
                    }
                    JOptionPane.showMessageDialog(null, VWResource.s_invalidBooleanFormat, VWResource.s_error, 1, null);
                    break;
                }
                default: {
                    this.appendToFilterString(this.m_dataTextField.getText());
                    break;
                }
            }
        }
        catch (VWException ex) {
            VWDebug.logException(ex);
            JOptionPane.showMessageDialog(null, ex.getLocalizedMessage(), VWResource.s_error, 1, null);
        }
    }

    private void appendToFilterString(String value) throws VWException {
        VWExposedFieldDefinition fieldDef = (VWExposedFieldDefinition)this.m_fieldsCombo.getSelectedItem();
        if (fieldDef == null) {
            return;
        }
        String operator = this.convertToSQLOperator((String)this.m_operatorsCombo.getSelectedItem());
        if (value == null) {
            this.m_filterString.append(fieldDef.getAuthoredName() + " " + operator + " ");
        } else {
            this.m_filterString.append(fieldDef.getAuthoredName() + " " + operator + " " + value);
        }
    }

    private String convertToSQLOperator(String op) {
        if (VWStringUtils.compare(op, VWResource.s_isEqualOp) == 0) {
            return "=";
        }
        if (VWStringUtils.compare(op, VWResource.s_notEqualOp) == 0) {
            return "<>";
        }
        if (VWStringUtils.compare(op, VWResource.s_isGreaterThanOp) == 0) {
            return ">";
        }
        if (VWStringUtils.compare(op, VWResource.s_isGreaterThanOrEqualOp) == 0) {
            return ">=";
        }
        if (VWStringUtils.compare(op, VWResource.s_isLessThanOp) == 0) {
            return "<";
        }
        if (VWStringUtils.compare(op, VWResource.s_isLessThanOrEqualOp) == 0) {
            return "<=";
        }
        if (VWStringUtils.compare(op, VWResource.s_likeOp) == 0) {
            return "like";
        }
        if (VWStringUtils.compare(op, VWResource.s_notLikeOp) == 0) {
            return "not like";
        }
        if (VWStringUtils.compare(op, VWResource.s_isNotNullOp) == 0) {
            return "is not null";
        }
        if (VWStringUtils.compare(op, VWResource.s_isNullOp) == 0) {
            return "is null";
        }
        return op;
    }
}

